% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskdiff.R
\name{riskdiff}
\alias{riskdiff}
\title{Risk difference}
\usage{
riskdiff(df, ...)
}
\arguments{
\item{df}{a dataframe with binary variables x and y or a 2 x 2 frequency table/matrix. If a table or matrix, x and y must be NULL. Used to select method.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list with class "rdiff" containing the following components:

\item{rd}{risk difference}
\item{conf.level}{specified confidence level}
\item{ci}{calculated confidence interval}
\item{p1}{proportion one}
\item{p2}{proportion two}
\item{tab}{2x2 table using for calculating risk difference}
}
\description{
Calculate risk difference and 95 percent confidence interval using Wald method.
}
\examples{
trial <- data.frame(
  disease = c(rep("yes", 2), rep("no", 2)),
  treatment = c(rep(c("estrogen", "placebo"), 2)),
  count = c(751, 623, 7755, 7479))

riskdiff(trial, treatment, disease, count, rev = "columns")

}
