% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aipw_ccombat_helpers.R
\name{cb.correct.apply_aipw_cComBat}
\alias{cb.correct.apply_aipw_cComBat}
\title{Fit AIPW ComBat model for batch effect correction}
\usage{
cb.correct.apply_aipw_cComBat(Ys, Ts, Xs, Model)
}
\arguments{
\item{Ys}{an \code{[n, d]} matrix, for the outcome variables with \code{n} samples in \code{d} dimensions.}

\item{Ts}{\code{[n]} the labels of the samples, with \code{K < n} levels, as a factor variable.}

\item{Xs}{\code{[n, r]} the \code{r} covariates/confounding variables, for each of the \code{n} samples, as a data frame with named columns.}

\item{Model}{a list containing the following parameters:
 \itemize{
    \item{\code{Prop_model}} Fitted propensity model
    \item{\code{Putcome_models}} List of fitted outcome models for each feature and treatment level
    \item{\code{Levels}} Levels of the treatment factor
    \item{\code{Treatment_effects}} Estimated treatment effects
    \item{\code{AIPW_est}} AIPW estimator results
    \item{\code{covar.out.form}} Formula used for the outcome model
 }
This model is output after fitting with \code{\link{cb.correct.aipw_cComBat}}.}
}
\value{
an \code{[n, d]} matrix, the batch-effect corrected data.
}
\description{
This function applies an Augmented Inverse Probability Weighting (AIPW) ComBat model 
for batch effect correction to new data.
}
\details{
Note: This function is experimental, and has not been tested on real data. It has only been tested with simulated data with binary (0 or 1) exposures.
}
\examples{
library(causalBatch)
sim <- cb.sims.sim_linear(a=-1, n=200, err=1/8, unbalancedness=3)
# fit batch effect correction for first 100 samples
cb.fit <- cb.correct.matching_cComBat(sim$Ys[1:100,,drop=FALSE], sim$Ts[1:100], 
                                  data.frame(Covar=sim$Xs[1:100,,drop=FALSE]), "Covar")
# apply to all samples
cor.dat <- cb.correct.apply_cComBat(sim$Ys, sim$Ts, data.frame(Covar=sim$Xs), cb.fit$Model)

}
