% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal-model.R
\name{check_constraints_violated}
\alias{check_constraints_violated}
\title{Check whether any of the observable constraints implied by the causal model are violated for a given distribution of observables}
\usage{
check_constraints_violated(obj, probs, tol = 1e-12)
}
\arguments{
\item{obj}{An object of class "causalmodel"}

\item{probs}{A named vector of observable probabilities, in the same order as obj$data$parameters}

\item{tol}{Tolerance for checking (in)equalities}
}
\value{
Either TRUE (violated) or FALSE (not violated) with messages indicating what constraints are violated if any.
}
\description{
Check whether any of the observable constraints implied by the causal model are violated for a given distribution of observables
}
\examples{
graph <- initialize_graph(graph_from_literal(Z -+ X, X -+ Y, Ur -+ X, Ur -+ Y))

iv_model <- create_causalmodel(graph, prob.form = list(out = c("X", "Y"), cond = "Z"))
check_constraints_violated(iv_model, probs = sample_distribution(iv_model))

}
