% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity_function.R
\name{sf}
\alias{sf}
\title{Calculate sensitivity of treatment effect estimate to unmeasured confounding}
\usage{
sf(z, e, form = "constant", c1 = 0, c0 = 0, s1 = 0, s0 = 0)
}
\arguments{
\item{z}{Treatment assignment (binary: 0 or 1)}

\item{e}{Propensity score value (numeric)}

\item{form}{Form of the sensitivity function (character: "constant" or
"linear")}

\item{c1}{Value of the sensitivity function when z = 1 (numeric)}

\item{c0}{Value of the sensitivity function when z = 0 (numeric)}

\item{s1}{Slope of the sensitivity function when z = 1 (numeric)}

\item{s0}{Slope of the sensitivity function when z = 0 (numeric)}
}
\value{
Sensitivity of treatment effect estimate to unmeasured confounding
(numeric)

sf(z, e, form)
}
\description{
This function calculates the sensitivity of a treatment effect estimate to
unmeasured confounding, as described in Rosenbaum (2002). The sensitivity is
defined as the maximum strength of association between the unmeasured
confounder and the treatment assignment that would be needed to explain away
the observed treatment effect estimate. This function assumes that the
treatment assignment is binary and that the outcome is continuous.
}
