% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOutbreaks.R
\name{getOutbreaks}
\alias{getOutbreaks}
\title{Execute a SOQL query against the Outbreak object}
\usage{
getOutbreaks(
  confirmedOnly = TRUE,
  openOnly = TRUE,
  healthUnit = NULL,
  from = "1990-01-01",
  to = as.character(Sys.Date()),
  columns = "Id"
)
}
\arguments{
\item{confirmedOnly}{Logical scalar. Should the query limit
results to confirmed outbreaks? Returns confirmed and suspect outbreaks
by default.}

\item{openOnly}{Logical scalar. Should the query limit
results to open outbreaks? Returns open and closed outbreaks
by default.}

\item{healthUnit}{Character vector or scalar. Names the Public Health Unit
used to filter the query. \code{getOutbreaks()} filters on Primary Health Unit.
Defaults to NULL (i.e. no health unit filter).}

\item{from}{Character scalar. Identifies the start of the date range
to include in the query. Defaults to the origin date of CCM.}

\item{to}{Character scalar. Identifies the end of the date range
to include in the query. Defaults to \code{Sys.Date()} (i.e. today's date).}

\item{columns}{Character scalar or character vector. Names the columns to
return from the Outbreak object. Defaults to \code{Id}.}
}
\value{
If the query succeeds, a \code{tibble} containing \code{columns}.
}
\description{
\code{getOutbreaks()} returns user-defined data from the CCM Outbreak object.
The Outbreak object maps to Outbreaks on the client-side.
}
\examples{
\dontrun{
Get all open outbreaks for Durham.
outbreaks <- getOutbreaks(
  confirmedOnly = FALSE,
  healthUnit = 'Durham Region Health Department'
)
Specify the data to return. This can be field names or labels
N.B. Names are case sensitive!
outbreaks <- getOutbreaks(
  columns = c("Id", "Outbreak Name", "Outbreak Number")
)
Limit the data to a specific time period.
outbreaks <- getOutbreaks(
  from = "2021-01-01",
  to = "2020-01-17"
)
}
}
