% Generated by roxygen2 (4.0.2): do not edit by hand
\name{leaderrank}
\alias{leaderrank}
\title{Find the LeaderRank in a directed graph}
\usage{
leaderrank(graph, vids = V(graph))
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the centrality values are returned. Default is all vertices.}
}
\value{
A numeric vector contaning the centrality scores for the selected vertices.
}
\description{
This function find the LeaderRank in a directed graph
}
\details{
Given a network consisting of N nodes and M directed links, a ground node connected with every node by a bidirectional link is added. Then, the network becomes strongly connected and consists of N+1 nodes and M+2N links (a bidirectional link is counted as two links with inverse directions). LeaderRank directly applies the standard random walk process to determine the score of every node. Accordingly, if the score of node \eqn{i}{i} at time step \eqn{t}{t} is \eqn{si(t)}{si(i)}, the dynamics can be described by an iterative process as:
\deqn{s_{i}(t+1)=\sum_{j=1}^{N+1}\frac{a_{ji}}{k_{j}^{out}}s_{j}(t)}{s_i(t+1)=sum(a(ji)/k(j, out) * s_j(t), j=1, N+1)}
where \eqn{a_{ji}}{a(ji)} is the element of the corresponding (N + 1)-dimensional adjacency matrix, which equals 1 if there is a directed link from \eqn{j}{j} to \eqn{i}{i} and 0 otherwise, and \eqn{k_{j}^{out}}{k(j)^out} is the out-degree of node \eqn{j}{j}. The process starts with the initialization where all node scores are 1 and will soon converge to a unique steady state denoted as \eqn{s_{i}^{\infty}, (i = 1, 2, ..., N, N+1)}{s(i)^ infty, (i = 1, 2, ..., N, N+1)}. LeaderRank ranks all nodes according to \eqn{s_{i}^{\infty}}{s(i)^infty}, and the nodes with larger final scores are considered to be more influential in spreading. \cr
More detail at \href{http://www.centiserver.org/?q1=centrality&q2=LeaderRank}{LeaderRank}
}
\examples{
g <- graph(c(1,2,2,3,3,4,4,2))
leaderrank(g)
}
\author{
Mahdi Jalili \email{m_jalili@farabi.tums.ac.ir}
}
\references{
Lu, Linyuan, et al. "Leaders in social networks, the delicious case." PloS one 6.6 (2011): e21202.
}

