% Generated by roxygen2 (4.0.2): do not edit by hand
\name{topocoefficient}
\alias{topocoefficient}
\title{Find the topological coefficient of a node in a undirected graph}
\usage{
topocoefficient(graph, vids = V(graph))
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the centrality values are returned. Default is all vertices.}
}
\value{
A numeric vector contaning the centrality scores for the selected vertices.
}
\description{
The topological coefficient is a relative measure for the extent to which a node shares neighbors with other nodes.
}
\details{
Topological coefficient \eqn{T_{n}}{T(n)} of a node \eqn{n}{n} with \eqn{k_{n}}{k(n)} neighbors defined as:
\deqn{T_{n}=\frac{avg(J(n,m))}{k_{n}}}{T(n)=avg(J(n,m))/k(n)}
where \eqn{J(n,m)}{J(n.m)} is defined for all nodes \eqn{m}{m} that share at least one neighbor with \eqn{n}{n}. The value \eqn{J(n,m)}{J(n,m)} is the number of neighbors shared between the nodes \eqn{n}{n} and \eqn{m}{m}, plus one if there is a direct link between \eqn{n}{n} and \eqn{m}{m}. \cr
Nodes that have one or no neighbors are assigned a topological coefficient of zero. \cr
More detail at \href{http://www.centiserver.org/?q1=centrality&q2=Topological_Coefficient}{Topological Coefficient}
}
\examples{
g <- graph(c(1,2,2,3,3,4,4,2), directed=FALSE)
topocoefficient(g)
}
\author{
Mahdi Jalili \email{m_jalili@farabi.tums.ac.ir}
}
\references{
Assenov, Yassen, et al. "Computing topological parameters of biological networks." Bioinformatics 24.2 (2008): 282-284.
}

