% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ord_res_fun.R
\name{kin_regr}
\alias{kin_regr}
\title{Degradation kinetics}
\usage{
kin_regr(x)
}
\arguments{
\item{x}{an \code{ord_res} object}
}
\value{
Returns either an \code{nls} or \code{lm} object based on the regression
performed by the function \code{\link[=det_order]{det_order()}}.
}
\description{
Returns from an \code{ord_res} object either the linear or the non-linear
regression of the degradation kinetics data.
}
\details{
After the
analysis in the phase space for the determination of the reaction order,
\code{\link[=det_order]{det_order()}} performs either a linear or a non-linear
regression of the kinetic data, depending on whether the reaction order is
n=0 or n>0,
respectively. To access the regression object call \code{kin_degr}.
}
\examples{
t <- c(0, 4, 8, 12, 16, 20)
conc <- c(1, 0.51, 0.24, 0.12, 0.07, 0.02)
dframe <- data.frame(t, conc)
res <- det_order(dframe)

kin_regr(res)
}
\seealso{
\code{\link[=det_order]{det_order()}}, \code{\link[=phase_space]{phase_space()}}, \code{\link[=results]{results()}}, \code{\link[stats:lm]{stats::lm()}}
}
