% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chyper.R
\name{mleN}
\alias{mleN}
\title{Maximum likelihood estimator for a unique population size in conditional hypergeometric distributions}
\usage{
mleN(population, k, s, n, m, verbose = T)
}
\arguments{
\item{population}{the index of the unique population to estimate}

\item{k}{the observed overlaps}

\item{s}{an integer representing the size of the intersecting population}

\item{n}{a vector of integers representing the sizes of each non-intersecting population where the value of the unknown population size should be any integer as a placeholder}

\item{m}{a vector of integers representing the sample sizes}

\item{verbose}{T/F should intermediate messages be printed?}
}
\value{
The maximum likelihood estimator of the unknown unique population size
}
\description{
Calculates the MLE of a unique population size in a conditional hypergeometric distribution: the distribution of how many items are in the overlap of all samples when samples of arbitrary size are each taken without replacement from populations of arbitrary size.
}
\examples{
mleN(1, c(0,0,1,1,0,2,0), 8, c(0,13,14), c(7,8,9))

}
