% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize_subject_ids.R
\name{correct_subject_ids}
\alias{correct_subject_ids}
\title{Correct the wrong subject IDs based on the user-provided values.}
\usage{
correct_subject_ids(data, target_columns, correction_table)
}
\arguments{
\item{data}{The input \code{<data.frame>} or \code{<linelist>}}

\item{target_columns}{A \code{<vector>} of column names with the subject ids.}

\item{correction_table}{A \code{<data.frame>} with the following two columns:
\describe{
\item{from}{a column with the wrong subject IDs}
\item{to}{a column with the values to be used to substitute the
incorrect ids.}
}}
}
\value{
The input dataset where all subject ids comply with the expected
format.
}
\description{
After detecting incorrect subject IDs from the \code{check_subject_ids()}
function, use this function to provide the correct IDs and perform the
substitution.
}
\examples{
data <- readRDS(
  system.file("extdata", "test_df.RDS", package = "cleanepi")
)
# detect the incorrect subject ids i.e. IDs that do not have any or both of
# the followings:
# - starts with 'PS',
# - ends with 'P2',
# - has a number within 1 and 100,
# - contains 7 characters.
dat <- check_subject_ids(
  data = data,
  target_columns = "study_id",
  prefix = "PS",
  suffix = "P2",
  range = c(1, 100),
  nchar = 7
)

# display rows with invalid subject ids
print_report(dat, "incorrect_subject_id")

# generate the correction table
correction_table <- data.frame(
  from = c("P0005P2", "PB500P2", "PS004P2-1"),
  to = c("PB005P2", "PB050P2", "PS004P2")
)

# perform the correction
dat <- correct_subject_ids(
  data = dat,
  target_columns = "study_id",
  correction_table = correction_table
)
}
