% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aemet_alert_zones.R
\name{aemet_alert_zones}
\alias{aemet_alert_zones}
\title{AEMET alert zones}
\source{
\url{https://www.aemet.es/es/eltiempo/prediccion/avisos/ayuda}. See also
Annex 2 and Annex 3 docs, linked in this page.
}
\usage{
aemet_alert_zones(verbose = FALSE, return_sf = FALSE)
}
\arguments{
\item{verbose}{Logical \code{TRUE/FALSE}. Provides information about the flow of
information between the client and server.}

\item{return_sf}{Logical \code{TRUE} or \code{FALSE}.
Should the function return an \code{\link[sf:sf]{sf}} spatial object? If \code{FALSE}
(the default value) it returns a \code{\link[tibble:tibble]{tibble}}. Note that
you need to have the \CRANpkg{sf} package installed.}
}
\value{
A \code{\link[tibble:tibble]{tibble}} or a \CRANpkg{sf} object.
}
\description{
Get AEMET alert zones.
}
\details{
The first result of the call on each session is (temporarily) cached in
the assigned \code{\link[=tempdir]{tempdir()}} for avoiding unneeded API calls.
}
\examples{
\dontshow{if (aemet_detect_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(tibble)
alert_zones <- aemet_alert_zones()
alert_zones

# Cached during this R session
alert_zones2 <- aemet_alert_zones(verbose = TRUE)

identical(alert_zones, alert_zones2)

# Select an map beaches
library(dplyr)
library(ggplot2)


# Galicia
alert_zones_sf <- aemet_alert_zones(return_sf = TRUE) \%>\%
  filter(COD_CCAA == "71")

# Coast zones are identified by a "C" in COD_Z
alert_zones_sf$type <- ifelse(grepl("C$", alert_zones_sf$COD_Z),
  "Coast", "Mainland"
)


ggplot(alert_zones_sf) +
  geom_sf(aes(fill = NOM_PROV)) +
  facet_wrap(~type) +
  scale_fill_brewer(palette = "Blues")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=aemet_alerts]{aemet_alerts()}}

Other aemet_api_data: 
\code{\link{aemet_alerts}()},
\code{\link{aemet_beaches}()},
\code{\link{aemet_daily_clim}()},
\code{\link{aemet_extremes_clim}()},
\code{\link{aemet_forecast_beaches}()},
\code{\link{aemet_forecast_daily}()},
\code{\link{aemet_forecast_fires}()},
\code{\link{aemet_last_obs}()},
\code{\link{aemet_monthly}},
\code{\link{aemet_normal}},
\code{\link{aemet_stations}()}
}
\concept{aemet_api_data}
