% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aemet_monthly.R
\name{aemet_monthly}
\alias{aemet_monthly}
\alias{aemet_monthly_clim}
\alias{aemet_monthly_period}
\alias{aemet_monthly_period_all}
\title{Monthly/annual climatology}
\usage{
aemet_monthly_clim(
  station = NULL,
  year = as.integer(format(Sys.Date(), "\%Y")),
  verbose = FALSE,
  return_sf = FALSE,
  extract_metadata = FALSE,
  progress = TRUE
)

aemet_monthly_period(
  station = NULL,
  start = as.integer(format(Sys.Date(), "\%Y")),
  end = start,
  verbose = FALSE,
  return_sf = FALSE,
  extract_metadata = FALSE,
  progress = TRUE
)

aemet_monthly_period_all(
  start = as.integer(format(Sys.Date(), "\%Y")),
  end = start,
  verbose = FALSE,
  return_sf = FALSE,
  extract_metadata = FALSE,
  progress = TRUE
)
}
\arguments{
\item{station}{Character string with station identifier code(s)
(see \code{\link[=aemet_stations]{aemet_stations()}}).}

\item{year}{Numeric value as date (format: \code{YYYY}).}

\item{verbose}{Logical \code{TRUE/FALSE}. Provides information about the flow of
information between the client and server.}

\item{return_sf}{Logical \code{TRUE} or \code{FALSE}.
Should the function return an \code{\link[sf:sf]{sf}} spatial object? If \code{FALSE}
(the default value) it returns a \code{\link[tibble:tibble]{tibble}}. Note that
you need to have the \CRANpkg{sf} package installed.}

\item{extract_metadata}{Logical \code{TRUE/FALSE}. On \code{TRUE} the output is
a \code{\link[tibble:tibble]{tibble}} with the description of the fields. See also
\code{\link[=get_metadata_aemet]{get_metadata_aemet()}}.}

\item{progress}{Logical, display a \code{\link[cli:cli_progress_bar]{cli::cli_progress_bar()}} object. If
\code{verbose = TRUE} won't be displayed.}

\item{start}{Numeric value as start year (format: \code{YYYY}).}

\item{end}{Numeric value as end year (format: \code{YYYY}).}
}
\value{
A \code{\link[tibble:tibble]{tibble}} or a \CRANpkg{sf} object.
}
\description{
Get monthly/annual climatology values for a station or all the stations.
\code{aemet_monthly_period()} and \code{aemet_monthly_period_all()} allows requests
that span several years.
}
\section{API Key}{
You need to set your API Key globally using \code{\link[=aemet_api_key]{aemet_api_key()}}.
}

\examples{
\dontshow{if (aemet_detect_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(tibble)
obs <- aemet_monthly_clim(station = c("9434", "3195"), year = 2000)
glimpse(obs)
\dontshow{\}) # examplesIf}
}
\seealso{
Other aemet_api_data: 
\code{\link{aemet_alert_zones}()},
\code{\link{aemet_alerts}()},
\code{\link{aemet_beaches}()},
\code{\link{aemet_daily_clim}()},
\code{\link{aemet_extremes_clim}()},
\code{\link{aemet_forecast_beaches}()},
\code{\link{aemet_forecast_daily}()},
\code{\link{aemet_forecast_fires}()},
\code{\link{aemet_last_obs}()},
\code{\link{aemet_normal}},
\code{\link{aemet_stations}()}
}
\concept{aemet_api_data}
