% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.r
\name{indicate_duplicates}
\alias{indicate_duplicates}
\title{Determine duplicate elements including their first occurrence.}
\usage{
indicate_duplicates(x)
}
\arguments{
\item{x}{A vector.}
}
\value{
A logical vector.
}
\description{
If an element is duplicated, all of its occurrence will be labeled \code{TRUE}.
Useful to list and compare all duplicates.
}
\examples{
indicate_duplicates(c(1, 2, NA, NA, 1))
indicate_duplicates(c(1, 2, 3, 4, 4))

# Useful to check duplicates in data frames.
df <- data.frame(
  id = c(1, 2, 1, 2, 3), year = c(2010, 2011, 2010, 2010, 2011),
  value = c(1, 2, 3, 4, 5)
)
df[indicate_duplicates(df[, c("id", "year")]), ]
}
