% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subgroup_forest.r
\name{subgroup_forest}
\alias{subgroup_forest}
\title{Create subgroup forest plot.}
\usage{
subgroup_forest(
  data,
  subgroup_vars,
  x,
  y,
  time = NULL,
  standardize_x = FALSE,
  covars = NULL,
  est_nsmall = 2,
  p_nsmall = 3,
  group_cut_quantiles = 0.5,
  save_plot = FALSE,
  filename = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{subgroup_vars}{A character vector of variable names to be used as subgroups. It's recommended that
the variables are categorical. If the variables are continuous, they will be cut into groups.}

\item{x}{A character string of the predictor variable.}

\item{y}{A character string of the outcome variable.}

\item{time}{A character string of the time variable. If \code{NULL}, logistic regression is used.
Otherwise, Cox proportional hazards regression is used.}

\item{standardize_x}{A logical value. If \code{TRUE}, the predictor variable will be standardized.}

\item{covars}{A character vector of covariate names. If duplicated with \code{subgroup_vars}, the duplicated
covariates will be temporarily removed during the corresponding subgroup analysis.}

\item{est_nsmall}{An integer specifying the precision for the estimates in the plot.}

\item{p_nsmall}{An integer specifying the number of decimal places for the p-values.}

\item{group_cut_quantiles}{A vector of numerical values between 0 and 1, specifying the quantile to use
for cutting continuous subgroup variables.}

\item{save_plot}{A logical value indicating whether to save the plot.}

\item{filename}{A character string specifying the filename for the plot. If \code{NULL}, a default filename is used.}

\item{...}{Additional arguments passed to the \code{forestploter::forest} function.}
}
\value{
A \code{gtable} object.
}
\description{
Create subgroup forest plot with \code{glm} or \code{coxph} models. The interaction p-values
are calculated using likelihood ratio tests.
}
\examples{
data(cancer, package = "survival")
# coxph model with time assigned
subgroup_forest(cancer,
  subgroup_vars = c("age", "sex", "wt.loss"), x = "ph.ecog", y = "status",
  time = "time", covars = "ph.karno", ticks_at = c(1, 2), save_plot = FALSE
)

# logistic model with time not assigned
cancer$dead <- cancer$status == 2
subgroup_forest(cancer,
  subgroup_vars = c("age", "sex", "wt.loss"), x = "ph.ecog", y = "dead",
  covars = "ph.karno", ticks_at = c(1, 2), save_plot = FALSE
)

cancer$ph.ecog_cat <- factor(cancer$ph.ecog, levels = c(0:3), labels = c("0", "1", ">=2", ">=2"))
subgroup_forest(cancer,
  subgroup_vars = c("sex", "wt.loss"), x = "ph.ecog_cat", y = "dead",
  covars = "ph.karno", ticks_at = c(1, 2), save_plot = FALSE
)
}
