% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exclusion_count.R
\name{exclusion_count}
\alias{exclusion_count}
\title{Count the number of excluded samples at each step}
\usage{
exclusion_count(.df, ..., .criteria_names = NULL, .na_exclude = TRUE)
}
\arguments{
\item{.df}{A data frame.}

\item{...}{Exclusion criteria. Logical expressions that define which rows to exclude.}

\item{.criteria_names}{An optional character vector of names for the criteria. If \code{NULL}, the expressions themselves
are used as names.}

\item{.na_exclude}{A logical value. If \code{TRUE}, rows where the criterion evaluates to \code{NA} will be excluded, and a
warning will be issued. Defaults to \code{FALSE}, where \code{NA} values are not excluded.}
}
\value{
A data frame with two columns: 'Criteria' and 'N', showing the number of samples at the start, the number
excluded at each step, and the final number remaining.
}
\description{
This function sequentially applies exclusion criteria to a data frame and counts the number of samples
removed at each step.
}
\examples{
cohort <- data.frame(
  age = c(17, 25, 30, NA, 50, 60),
  sex = c("M", "F", "F", "M", "F", "M"),
  value = c(1, NA, 3, 4, 5, NA),
  dementia = c(TRUE, FALSE, FALSE, FALSE, TRUE, FALSE)
)
exclusion_count(
  cohort,
  age < 18,
  is.na(value),
  dementia == TRUE,
  .criteria_names = c(
    "Age < 18 years",
    "Missing value",
    "History of dementia"
  )
)
}
