% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictor_effect_plot.R
\name{predictor_effect_plot}
\alias{predictor_effect_plot}
\title{Plot the effect of a predictor variable}
\usage{
predictor_effect_plot(
  data,
  x,
  y,
  time = NULL,
  time2 = NULL,
  covars = NULL,
  cluster = NULL,
  method = "auto",
  knot = 4,
  add_hist = TRUE,
  ref = "x_median",
  ref_digits = 3,
  show_total_n = TRUE,
  group_by_ref = TRUE,
  group_title = NULL,
  group_labels = NULL,
  group_colors = NULL,
  breaks = 20,
  line_color = "#e23e57",
  print_p_ph = TRUE,
  trans = "identity",
  save_plot = FALSE,
  create_dir = FALSE,
  filename = NULL,
  y_lim = NULL,
  hist_max = NULL,
  xlim = NULL,
  height = 6,
  width = 6,
  return_details = FALSE
)
}
\arguments{
\item{data}{A data frame.}

\item{x}{A character string of the predictor variable.}

\item{y}{A character string of the outcome variable.}

\item{time}{A character string of the time variable for Cox models. If \code{NULL}, logistic or linear regression is used.}

\item{time2}{A character string of the ending time for interval-censored or counting process data.}

\item{covars}{A character vector of covariate names.}

\item{cluster}{A character string of the cluster variable for robust variance estimation.}

\item{method}{A character string specifying the method for handling the predictor \code{x}.
Can be \code{"auto"}, \code{"rcs"}, \code{"linear"}, or \code{"categorical"}. If \code{"auto"}, the function decides based on the type of \code{x}.}

\item{knot}{The number of knots for RCS. If \code{NULL}, AIC is used to find the optimal number.}

\item{add_hist}{A logical value. If \code{TRUE}, add a distribution plot (histogram or bar plot).}

\item{ref}{The reference value for numeric predictors, or the reference level for categorical predictors.
For numeric \code{x}, can be \code{"x_median"}, \code{"x_mean"}, \code{"ratio_min"}, or a numeric value.}

\item{ref_digits}{The number of digits for the reference value label.}

\item{show_total_n}{A logical value. If \code{TRUE}, show the total number of samples.}

\item{group_by_ref}{A logical value. If \code{TRUE} and \code{x} is numeric, split the histogram at the reference value.}

\item{group_title}{A character string for the group legend title.}

\item{group_labels}{A character vector for group labels.}

\item{group_colors}{A character vector of colors for the distribution plot. If \code{NULL}, the default colors are used.
If \code{group_by_ref} is \code{FALSE}, the first color is used as fill color.}

\item{breaks}{The number of breaks for the histogram.}

\item{line_color}{The color for the effect line/points.}

\item{print_p_ph}{A logical value. If \code{TRUE} (and model is Cox), print the p-value for the proportional hazards test.}

\item{trans}{The transformation for the y-axis. Passed to \code{ggplot2::scale_y_continuous(transform = trans)}.}

\item{save_plot}{A logical value indicating whether to save the plot.}

\item{create_dir}{A logical value for creating the save directory.}

\item{filename}{A character string for the saved plot filename.}

\item{y_lim}{The y-axis limits.}

\item{hist_max}{The maximum value for the histogram y-axis.}

\item{xlim}{The x-axis limits for numeric predictors. If \code{NULL}, the limits are the \code{0.025} and \code{0.975} quantiles.
The actual plot range might be slightly larger than this range to fit the histogram.}

\item{height}{The height of the saved plot.}

\item{width}{The width of the saved plot.}

\item{return_details}{A logical value indicating whether to return plot details.}
}
\value{
A \code{ggplot} object, or a list with the plot and details if \code{return_details} is \code{TRUE}.
}
\description{
This is a versatile function to plot the relationship between a predictor variable and the outcome.
It supports numeric (linear or RCS) and categorical predictors for logistic, linear, and Cox models.
It can display the distribution of the predictor variable as a histogram (for numeric) or bar plot (for categorical).
}
\examples{
data(cancer, package = "survival")
cancer$dead <- cancer$status == 2
cancer <- cancer[!is.na(cancer$inst), ]
predictor_effect_plot(
  data = cancer,
  x = "age",
  y = "dead",
  method = "linear",
  covars = "ph.karno",
  add_hist = FALSE,
  trans = "log2",
  save_plot = FALSE,
  cluster = "inst"
)
}
