
#' a function to demo the clitable package
#' @return nothing
#' @export 
#' @examples 
#' demo()
demo <- function() {
  df <- head(datasets::iris)
  ####################
  cli::cli_h1("clitable border styles")

  for (style in names(BOX_STYLES)) {
    cli::cli_h2(paste("style:", style, "\n"))
    cat(cli_table(df, border_style = style), sep = "\n")
    cat(cli_table(df, border_style = style, header = FALSE), sep = "\n")
  }

  ####################
  cli::cli_h1("heatmap columns")

  df <- head(datasets::mtcars, 10)
  cli::cli_h2("default heatmap settings")
  ct <- cli_table(df, heatmap_columns = list(1, "hp", "carb"))
  cat(ct, sep = "\n")

  ## with custom colors
  cli::cli_h2("heatmap custom colors")
  ct <- cli_table(df, heatmap_columns = list(1, 4, "carb"), heatmap_colorspace = c("blue", "yellow"))
  cat(ct, sep = "\n")

  ## with custom range
  ct <- cli_table(df, heatmap_columns = 1, xmin = 18, xmax = 22)
  cli::cli_h2("heatmap custom range")
  cat(ct, sep = "\n")

  ####################
  cli::cli_h1("hilite rows")
  df <- head(datasets::mtcars, 10)
  ct <- cli_table(df, hilite_rows = c(3, 1, 7))
  cat(ct, sep = "\n")

  ########################
  cli::cli_h1("combined")
  df <- head(datasets::mtcars, 10)
  ct <- cli_table(df, heatmap_columns = list(1, 4, "carb"), hilite_rows = df$hp > 150, hilite_style = "yellow")
  cat(ct, sep = "\n")


  ####################
  cli::cli_h1("not all numeric")
  df <- head(datasets::penguins)
  df$sex <- ifelse(!is.na(df$sex) & df$sex == "female", crayon::blue$underline$bold(df$sex), df$sex)
  ct <- cli_table(df)
  cat(ct, sep = "\n")

  ###############################
  cli::cli_h1("all bells and whistles")
  df <- head(datasets::penguins, 20)

  df$species <- as.character(df$species)

  df[1, 1] <- crayon::style("ADELIE", "underline","bgYellow")
  ct <- cli_table(df, header_style = "bold",
    NA_style = "strikethrough",
    heatmap_columns = list("flipper_len"), xmin = 180, xmax = 200,
    hilite_rows = !is.na(df$sex) & df$sex == "female" & df$bill_dep >= 19, 
    hilite_style = "bgGreen"
  )
  cat(ct, sep = "\n")
}