% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppstdint2.R
\name{ppstdint2}
\alias{ppstdint2}
\title{Circulating capital model 2 using the Standard Interpretation.}
\usage{
ppstdint2(A, Ap, l, b, Q, Qp, lp_simple)
}
\arguments{
\item{A}{input-output matrix (n x n).}

\item{Ap}{input-output matrix for the subset of productive industries (m x m).}

\item{l}{vector of complex labor input (1 x n).}

\item{b}{vector real wage bundle (n x 1).}

\item{Q}{gross output vector (n x 1).}

\item{Qp}{gross output vector for the subset of productive industries (m x 1).}

\item{lp_simple}{vector of simple labor input for the subset of productive industries (1 x m).}
}
\value{
A list with the following elements:
\item{meig}{Maximum eigen value of M}
\item{urop}{Uniform rate of profit (as a fraction)}
\item{mrop}{Maximum rate of profit (as a fraction)}
\item{ppabs}{Price of production vector (absolute)}
\item{pprel}{Price of production vector (relative)}
\item{lvalues}{Labor values vector}
\item{dprice}{Direct price vector}
\item{mevg}{Monetary expression of value using gross output}
\item{mnonneg}{Is M Nonnegative? (1=Y,0=N)}
\item{mirred}{Is M Irreducible? (1=Y,0=N)}
}
\description{
This function computes the uniform rate of profit, prices of production and labor values for a circulating capital model using the Standard Interpretation. The model has uniform wage rates across industries and takes into account unproductive labor for labor value calculations.
}
\examples{

# ------ Data
# Input-output matrix
A <- matrix(
data = c(0.265,0.968,0.00681,0.0121,0.391,0.0169,0.0408,0.808,0.165),
nrow=3, ncol=3, byrow = TRUE
)
# Direct labor input vector (complex)
l <- matrix(
data = c(0.193, 3.562, 0.616),
nrow=1
)
# Real wage bundle
b <- matrix(
data = c(0.0109, 0.0275, 0.296),
ncol=1
)
# Gross output vector
Q <- matrix(
data = c(26530, 18168, 73840),
ncol=1
)
# Direct labor input vector (simple)
l_simple <- l
# Compute prices of production
ppstdint2(A=A,Ap=A[1:2,1:2],l=l,b=b,Q=Q,Qp=Q[1:2,1],lp_simple=l[1,1:2])

}
\references{
Basu, Deepankar and Moraitis, Athanasios, "Alternative Approaches to Labor Values andPrices of Production: Theory and Evidence" (2023). Economics Department Working Paper Series. 347. URL: https://scholarworks.umass.edu/econ_workingpaper/347/
}
