% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkConceptMapData.R
\name{checkConceptMapData}
\alias{checkConceptMapData}
\title{Validate Concept Map Data}
\usage{
checkConceptMapData(CMData)
}
\arguments{
\item{CMData}{A data frame containing concept map data. This data frame must include
the required columns: "sorterID", "statement", and "stackID".}
}
\value{
Returns \code{TRUE} if all checks pass. If any check fails, an error is raised
with a descriptive message.
}
\description{
Checks whether the provided data frame meets the requirements for concept map data.
}
\details{
This function performs the following checks on the input data:
\itemize{
\item Verifies that \code{CMData} is a data frame.
\item Ensures the presence of required columns: \code{"sorterID"}, \code{"statement"}, and \code{"stackID"}.
\item Confirms that there are at least 2 unique values in the \code{"stackID"} column.
\item Confirms that there are at least 2 unique values in the \code{"sorterID"} column.
\item Confirms that there are at least 2 unique values in the \code{"statement"} column.
}
}
\examples{
# Example of valid data
validData <- data.frame(
  sorterID = c("resp1", "resp1", "resp1", "resp2",
   "resp2", "resp2", "resp3", "resp3", "resp3"),
  statement = c("London", "Frankfurt", "Berlin", "London",
  "Frankfurt", "Berlin", "London", "Frankfurt", "Berlin"),
  stackID = c("capital city", "city", "capital city", 1, 2, 2, "A", "B", "A")
)
checkConceptMapData(validData) # Should return TRUE

# Example of invalid data (missing columns)
invalidData <- data.frame(
  sorterID = c(1, 2),
  stackID = c(1, 2)
)
# checkConceptMapData(invalidData) # Will return False as an error

}
