% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createStatementOverview.R
\name{createStatementOverview}
\alias{createStatementOverview}
\title{Create an Overview of Statements in Concept Map Data}
\usage{
createStatementOverview(CMData)
}
\arguments{
\item{CMData}{A data frame containing concept map data. This must include a column named \code{"statement"}.}
}
\value{
A data frame with two columns: \code{StatementNumber} and \code{Statement}.
Each row represents a unique statement with its corresponding number.
}
\description{
This function generates an overview of all unique statements in a given concept mapping dataset.
The function assigns a unique statement number to each distinct statement and returns a summary data frame.
}
\details{
The function first checks if the provided dataset is suitable for concept mapping using the \cr
\code{checkConceptMapData} function. If the data is valid, it assigns a numeric statement number
to each distinct statement, ordered by their appearance in the dataset. The function then generates
an overview where each statement is paired with its corresponding statement number.
}
\examples{
# Example of valid data
CMData <- data.frame(
    sorterID = c("resp1", "resp1", "resp1", "resp2",
     "resp2", "resp2", "resp3", "resp3", "resp3"),
   statement = c("London", "Frankfurt", "Berlin", "London",
    "Frankfurt", "Berlin", "London", "Frankfurt", "Berlin"),
    stackID = c("capital city", "city", "capital city", 1, 2, 2, "A", "B", "A")
)

# Create an overview of the statements
createStatementOverview(CMData)

}
