% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power-sim.R
\name{power_sim_dual}
\alias{power_sim_dual}
\title{Rejection rate for dual acceptance criteria based via simulation}
\usage{
power_sim_dual(
  n_qual,
  m_equiv,
  replicates,
  distribution = "rnorm",
  param_qual,
  param_equiv,
  k1,
  k2
)
}
\arguments{
\item{n_qual}{the sample size of the qualification sample}

\item{m_equiv}{the sample size of the equivalency/acceptance sample}

\item{replicates}{the number of simulated qualification samples and
equivalency samples. If a single value is given, the
same numbers used for both, if a vector of length two
is given, the first element is the number of qualification
replicates and the second element is the number of
equivalency replicates.}

\item{distribution}{a function name for generating a random sample
(defaults to "rnorm")}

\item{param_qual}{a data.frame (must be single row) with columns matching the
arguments of the distribution function}

\item{param_equiv}{a data.frame with columns matching the arguments of the
distribution function. The simulation is repeated with
the parameters specified in each row of the data.frame.}

\item{k1}{a factor for determining the acceptance criterion for sample
minimum, which is calculated as \code{mean_qual - k1 * sd_qual}}

\item{k2}{a factor for determining the acceptance criterion for sample
average, which is calculated as \code{mean_qual - k2 * sd_qual}}
}
\value{
A \code{data.frame}. The first column(s) are duplicate of the \code{data.frame}
passed in the argument \code{param_equiv}. The last column is named
\verb{Rejection Rate} and has a value equal to the number of samples rejected
for each simulation run.
}
\description{
Performs Monte Carlo simulation to determine the rejection rate of a
dual acceptance criteria (based on sample minimum and mean). By specifying
several sets of parameters for the "equivalency" distribution, a power
curve for the acceptance test can be determined.
}
\details{
This function performs simulation to estimate the performance of the
dual acceptance criteria commonly used for composite materials in
aerospace applications. These criteria are based on setting lower limits
on the minimum individual (lower extremum) and the mean of an "acceptance"
sample. These limits are computed based on the sample mean and sample
standard deviation of an initial "qualification" sample. The criteria
are intended to be a test of non-inferiority to determine if the material
lots from which the "acceptance" samples are drawn should be accepted for
production. Another common use of these criteria are to determine if a
process change, equipment change, or second manufacturing site is
acceptable for production.

For each set of distribution parameters given by the rows of \code{param_equiv},
a number of samples of size \code{m_equiv} are generated using the function
\code{distribution}. Next, a number of qualification samples of size \code{n_qual}
are generated
using the \code{distribution} function and the parameters given in \code{param_qual}.
Limits for minimum and average are determined for each qualification
sample. Each equivalency sample is compared with the limits determined
from each qualification sample. The number of replicate in this simulation
is given by \code{replicates}: if this is a vector of length two, the first
element is the number of qualification samples and the second is the number
of equivalency samples; if \code{replicates} is a single value, the same number
is used for the number of qualification samples and acceptance samples.
Therefore, for each row of \code{param_equiv} a total of
\code{replicates[1] * replicates[2]} criteria are evaluated.

The argument \code{distribution} must correspond with a function that generates
(pseudo) random numbers. This function must have an argument \code{n} that
specifies the sample size to be generated. When the argument \code{distribution}
matches certain common distribution functions (such as \code{rnorm}), the C++
implementation of the random number generation function is used instead of
calling R code, which results in a significant speedup.
}
\examples{
# Compute a power curve for a dual acceptance criteria for a qualification
# sample size of 18 and an equivalency sample size of 6, using 2000
# replicates. A standard normal distribution is used and the power to
# detect a decrease in mean is determined.
set.seed(12345) # make it reproducible
power_sim_dual(
  18, 6,
  2000,
  "rnorm",
  data.frame(mean = 0, sd = 1),
  data.frame(mean = c(-2, -1.5, -1, 0.5, 0), sd = 1),
  2.959, 0.954
)
##   mean sd Rejection Rate
## 1 -2.0  1     0.98349975
## 2 -1.5  1     0.88186900
## 3 -1.0  1     0.56382425
## 4  0.5  1     0.00864025
## 5  0.0  1     0.04826250

}
\seealso{
\code{\link{k_equiv_two_sample}}
}
