% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefa_fixdia.R
\name{coefa_fixdia}
\alias{coefa_fixdia}
\title{Fix(Replace) the diagonal values in the matrix}
\usage{
coefa_fixdia(x,test=FALSE,sz)
}
\arguments{
\item{x}{A matrix that needs to replace the value of the diagonal in matrix.}

\item{test}{A logical value.If test=TRUE,KMO and Bartlett's test will be done.}

\item{sz}{The total sample sizes of include studies.}
}
\value{
A matrix or a list containing KMO and Bartlett's test.
}
\description{
The diagonal of the matrix is replaced by 1 ,so that the matrix can be
tested for KMO and Bartlett's test.
}
\details{
The diagonal of the similarity matrix will be adjusted by this
function, COEFA results will be more accurate, and KMO and Bartlett' Test
 tests can be carried out.

 If test=FALSE,you will obtain a more accurate
 result without KMO and Bartlett's test. If test= TRUE ,you would obtain
 a result containing KMO and Bartlett's Test ,similarity matrix fixed.
}
\examples{
#similarity matrix——matrices_acm
\donttest{fixedsmatrix<-coefa_fixdia(matrices_acm,sz=100)}
}
