% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readwrite.R
\name{scissors}
\alias{scissors}
\title{Remove the first n iterations.}
\usage{
scissors(burnin, set = get("info"), write = TRUE, save.info = TRUE)
}
\arguments{
\item{burnin}{Number of iterations to remove of the iterative time series. If this value is higher than the amount of remaining iterations,
a warning is given and the iterations are not removed. If the provided number is negative, the iterations will be removed from the end of the run, not from the start. If a range is given, this range of iterations is removed.}

\item{set}{Detailed information of the current run, stored within this session's memory as variable \code{info}.}

\item{write}{Whether or not to write the changes to the output file. Defaults to TRUE.}

\item{save.info}{Whether or not to store a variable `info' in the session which contains the run input, output and settings. Defaults to \code{save.info=TRUE}.}
}
\value{
NA
}
\description{
Removes iterations of the MCMC time series, and then updates the output files.
}
\details{
The strat function will perform thousands millions of MCMC iterations, although usually only a fraction of these will be stored. 
The remaining MCMC iterations should be well mixed (the upper panel
of the fit of the iterations should show no undesirable features such as trends or sudden systematic drops or rises).
If the run has a visible remaining burn-in, scissors can be used to remove them.
To remove, e.g., the first 300 iterations, type \code{scissors(300)}. To remove the last 300 iterations, type \code{scissors(-300)}. To remove iterations 300 to 600, type \code{scissors(300:600)}.
}
