% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequ.R
\name{concstats_grs}
\alias{concstats_grs}
\title{GRS measure}
\usage{
concstats_grs(x, na.rm = TRUE)
}
\arguments{
\item{x}{A non-negative numeric vector.}

\item{na.rm}{a logical vector that indicates whether \code{NA} values should
be excluded or not. Must be either \code{TRUE} or \code{FALSE}. The default
is \code{TRUE}.
If set to \code{FALSE} the computation yields \code{NA} if vector contains
\code{NA} values.}
}
\value{
A single numeric measure in decimal form.
}
\description{
GRS measure
}
\examples{
# a vector of market shares
x <- c(0.4, 0.2, 0.25, 0.1, 0.05)
concstats_grs(x)
# a vector with NA values
x <- c(0.4, 0.2, 0.25, 0.1, 0.05, NA)
concstats_grs(x, na.rm = FALSE)

}
\references{
Ginevicius, R. and S. Cirba (2009). "Additive measurement of
market concentration", \emph{Journal of Business Economics and Management},
10(3), 191-198.
}
