% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_cramersv.R
\name{ci_chisq_ncp}
\alias{ci_chisq_ncp}
\title{CI for the NCP of the Chi-Squared Distribution}
\usage{
ci_chisq_ncp(
  x,
  probs = c(0.025, 0.975),
  correct = TRUE,
  type = c("chi-squared", "bootstrap"),
  boot_type = c("bca", "perc", "norm", "basic"),
  R = 9999L,
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{The result of \code{\link[stats:chisq.test]{stats::chisq.test()}}, a matrix/table of counts, or
a \code{data.frame} with exactly two columns representing the two variables.}

\item{probs}{Lower and upper probabilities, by default \code{c(0.025, 0.975)}.}

\item{correct}{Should Yates continuity correction be applied to the 2x2 case? The
default is \code{TRUE} (also used in the bootstrap), which differs from \code{\link[=ci_cramersv]{ci_cramersv()}}.}

\item{type}{Type of CI. One of "chi-squared" (default) or "bootstrap".}

\item{boot_type}{Type of bootstrap CI. Only used for \code{type = "bootstrap"}.}

\item{R}{The number of bootstrap resamples. Only used for \code{type = "bootstrap"}.}

\item{seed}{An integer random seed. Only used for \code{type = "bootstrap"}.}

\item{...}{Further arguments passed to \code{\link[boot:boot]{boot::boot()}}.}
}
\value{
An object of class "cint", see \code{\link[=ci_mean]{ci_mean()}} for details.
}
\description{
This function calculates CIs for the non-centrality parameter (NCP) of the
\eqn{\chi^2}-distribution. A positive lower \eqn{(1 - \alpha) \cdot 100\%}-confidence
limit for the NCP goes hand-in-hand with a significant association test at level
\eqn{\alpha}.
}
\details{
By default, CIs are computed by Chi-squared test inversion. This can be unreliable
for very large test statistics. The default bootstrap type is "bca".
}
\examples{
ci_chisq_ncp(mtcars[c("am", "vs")])
ci_chisq_ncp(mtcars[c("am", "vs")], type = "bootstrap", R = 999)  # Use larger R
}
\references{
Smithson, M. (2003). Confidence intervals. Series: Quantitative Applications in the
Social Sciences. New York, NY: Sage Publications.
}
\seealso{
\code{\link[=ci_cramersv]{ci_cramersv()}}
}
