% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildPattern.R
\name{buildPattern}
\alias{buildPattern}
\title{Build a pattern}
\usage{
buildPattern(n, parts, probs)
}
\arguments{
\item{n}{A natural number. This specifies the number of data points to build.}

\item{parts}{A natural number. This specifies the parts that make up the pattern.}

\item{probs}{A number between 0 and 1.}
}
\value{
A vector.
}
\description{
Builds data based on a pattern. This function uses another internal function \code{\link{genPattern}}.
}
\details{
This function helps in generating data based on a pattern. To explain in simple terms, this function aims to perform the exact opposite of a regular expression i.e regex function. In other words, this function generates data given a generic pattern.
The steps in the process of building data from a pattern is as follows.
\enumerate{
\item Identify the parts that make up the data. Ideally, these parts have a pattern and a probabilistic distribution of their own. For example, a phone number has three parts namely, country code, area code and a number.
\item Assign probabilities to each of the above parts. If a part contains only one member, then the corresponding probability must be 1. However, if there are multiple members in the part, then each member must have a probability provided in the respective order.
}
}
\examples{
parts <- list(c("+91","+44","+64"), c(491,324,211), c(7821:8324))
probs <- list(c(0.25,0.25,0.50), c(0.30,0.60,0.10), c())
phoneNumbers <- buildPattern(n=20,parts = parts, probs = probs)
head(phoneNumbers)
parts <- list(c("+91","+44","+64"), c("("), c(491,324,211), c(")"), c(7821:8324))
probs <- list(c(0.25,0.25,0.50), c(1), c(0.30,0.60,0.10), c(1), c())
phoneNumbers <- buildPattern(n=20,parts = parts, probs = probs)
head(phoneNumbers)
}
\seealso{
\code{\link{genPattern}}.
}
