% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textbox.R
\name{textbox}
\alias{textbox}
\alias{grid.textbox}
\title{Create a box with text}
\usage{
textbox(
  text,
  x = unit(0.5, "npc"),
  y = unit(0.5, "npc"),
  just = c("center", "left", "right"),
  txt_gp = getOption("txt_gp", default = gpar(color = "black", cex = 1)),
  box_fn = roundrectGrob,
  box_gp = getOption("box_gp", default = gpar(fill = "white")),
  name = "textbox"
)

grid.textbox(...)
}
\arguments{
\item{text}{A character text to be passed to \link[grid]{textGrob}.}

\item{x}{A number or unit object specifying x-location.}

\item{y}{A number or unit object specifying y-location.}

\item{just}{The justification of the text, `"left"`, `"right` and `"center"`.
See \link[grid]{textGrob} for more details.}

\item{txt_gp}{An object of class \link[grid]{gpar} style to be applied to the
text. This will also be read from global options of \code{"txt_gp"}. For
example, if one wants to set a font size for all the text inside box,
\code{options(txt_gp = gpar(cex = 0.8))} will do the trick.}

\item{box_fn}{Function to create box for the text. Parameters of `x=0.5`,
`y=0.5` and `box_gp` will be passed to this function and return a \code{grob}
object. This will also be read from global options of \code{"box_gp"}.}

\item{box_gp}{An object of class \link[grid]{gpar} style to be applied to the
box.}

\item{name}{A character identifier.}

\item{...}{Parameters passed to \code{textbox}}
}
\value{
A text box grob. grid.textbox() returns the value invisibly.
}
\description{
Create a \link[grid]{grob} with text inside. To extract the units describing
grob boundary location can be accessed with \link[grid]{grobX} and
 \link[grid]{grobY}. The units describing width and height can be accessed with
 \link[grid]{grobWidth} and \link[grid]{grobHeight}.
}
\examples{
fg <- textbox(text = "This is a test")
grid::grid.draw(fg)
grid.textbox(text = "This is a test")
grid.textbox(text = "This is a test")
}
