% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_parameters.R
\name{.make_parameters}
\alias{.make_parameters}
\title{Make parameters for contrast code call}
\usage{
.make_parameters(
  formula,
  params = list(factor_col = NA, code_by = NA, reference_level = NA, intercept_level =
    NA, drop_trends = NA, labels = NULL, as_is = FALSE),
  env = NULL,
  verbose = TRUE
)
}
\arguments{
\item{formula}{Formula given by user}

\item{params}{Parameter accumulator}

\item{env}{Environment for the formula, on the first recursion this will be
pulled from \code{formula} and then passed to subsequent recursions. Needed to
check whether a function is actually a function.}

\item{verbose}{Logical, default \code{TRUE}, whether to show drop_trends warning
if used incorrectly}
}
\value{
Named list of parameters that can be evaluated in
\code{\link[=.process_contrasts]{.process_contrasts()}}
}
\description{
Given a formula, recursively go through the abstract syntax tree and
extract the necessary parameters for \code{\link[=use_contrasts]{use_contrasts()}}. While this method is
more involved than extracting from a parsed string representation, I think
it handles matrix calls better since it plucks the call right out of
the syntax tree.
}
\keyword{internal}
