% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordschur.R
\name{ordschur}
\alias{ordschur}
\title{Ordered schur decomposition}
\usage{
ordschur(Ui, Si, idx)
}
\arguments{
\item{Ui}{Square upper-triangular matrix matrix from schur decomposition. If Ui is not given it is set to the identity matrix.}

\item{Si}{Orthogonal matrix from schur decomposition}

\item{idx}{array index}
}
\value{
Returns a list of ordered (U, S)
}
\description{
\code{ordschur} Orders a schur decomposition
}
\details{
\code{ordschur} finds an orthogonal matrix, \code{U} so that the eigenvalues
appearing on the diagonal of \code{Si} are ordered according to the
increasing values of the array index where the i-th element
of index corresponds to the eigenvalue appearing as the
element  \code{Si[i,i]}.

\code{ordschur} could also be used in this syntax:  \code{ordschur(Si, idx)}
}
