% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_sequence.R
\name{sem_sim_seq}
\alias{sem_sim_seq}
\title{Calculate semantic similarity sequence for a single dyad}
\usage{
sem_sim_seq(conversation, method = "tfidf", window_size = 3, ...)
}
\arguments{
\item{conversation}{A data frame representing the conversation}

\item{method}{A character string specifying the method to use: "tfidf", "word2vec", or "glove"}

\item{window_size}{An integer specifying the size of the sliding window}

\item{...}{Additional arguments passed to semantic_similarity}
}
\value{
A list containing the sequence of similarities and the average similarity
}
\description{
This function calculates semantic similarity over a sequence of conversation exchanges within a single dyad.
}
\examples{
conversation <- data.frame(
  processed_text = c("The weather is nice", "It's a beautiful day",
                     "The sun is shining", "Perfect day for a picnic")
)
result <- sem_sim_seq(conversation, method = "tfidf", window_size = 2)
print(result)
}
