% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_functions.R
\name{topic_similarity}
\alias{topic_similarity}
\title{Calculate topic similarity between two conversations}
\usage{
topic_similarity(conv1, conv2, method = "lda", num_topics = 2)
}
\arguments{
\item{conv1}{A character vector representing the first conversation}

\item{conv2}{A character vector representing the second conversation}

\item{method}{A character string specifying the method to use: "lda" or "lsa"}

\item{num_topics}{An integer specifying the number of topics to use in the model}
}
\value{
A numeric value representing the topic similarity
}
\description{
This function calculates the topic similarity between two conversations using either
Latent Dirichlet Allocation (LDA) or Latent Semantic Analysis (LSA).
}
\examples{
conv1 <- c("I love pizza", "Pizza is my favorite food")
conv2 <- c("I prefer pasta", "Pasta is delicious")
topic_similarity(conv1, conv2, method = "lda", num_topics = 2)
topic_similarity(conv1, conv2, method = "lsa", num_topics = 2)
}
