% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecdf.inv.R
\name{ecdf.inv}
\alias{ecdf.inv}
\title{Obtaining the inverse of marginal empirical cumulative distribution (ECDF)}
\usage{
ecdf.inv(x, p, sort.flag = TRUE)
}
\arguments{
\item{x}{A vector of numbers which is the marginal empirical data.}

\item{p}{A vector of numbers which is the probability of the simulated data.}

\item{sort.flag}{A logical value to specify whether to sort the output data.}
}
\value{
The inverse values of \code{p} based on ECDF of \code{x}.
}
\description{
Obtaining the inverse of marginal empirical cumulative distribution (ECDF)
}
\examples{
ecdf.inv(0:10, c(0.25, 0.75))
ecdf.inv(0:10, c(0.25, 0.75), FALSE)
}
