% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bioclim_example}
\alias{bioclim_example}
\title{Example Bioclimatic Data for Ecological Modeling}
\format{
A data frame with 100 rows and 20 variables:
\describe{
\item{species_richness}{Integer. Number of species observed (response variable)}
\item{BIO1}{Numeric. Annual Mean Temperature}
\item{BIO2}{Numeric. Mean Diurnal Range}
\item{BIO3}{Numeric. Isothermality}
\item{BIO4}{Numeric. Temperature Seasonality}
\item{BIO5}{Numeric. Max Temperature of Warmest Month}
\item{BIO6}{Numeric. Min Temperature of Coldest Month}
\item{BIO7}{Numeric. Temperature Annual Range}
\item{BIO8}{Numeric. Mean Temperature of Wettest Quarter}
\item{BIO9}{Numeric. Mean Temperature of Driest Quarter}
\item{BIO10}{Numeric. Mean Temperature of Warmest Quarter}
\item{BIO11}{Numeric. Mean Temperature of Coldest Quarter}
\item{BIO12}{Numeric. Annual Precipitation}
\item{BIO13}{Numeric. Precipitation of Wettest Month}
\item{BIO14}{Numeric. Precipitation of Driest Month}
\item{BIO15}{Numeric. Precipitation Seasonality}
\item{BIO16}{Numeric. Precipitation of Wettest Quarter}
\item{BIO17}{Numeric. Precipitation of Driest Quarter}
\item{BIO18}{Numeric. Precipitation of Warmest Quarter}
\item{BIO19}{Numeric. Precipitation of Coldest Quarter}
}
}
\source{
Simulated data based on the 19 WorldClim bioclimatic variables
}
\usage{
bioclim_example
}
\description{
A simulated dataset with the 19 WorldClim bioclimatic variables
(https://www.worldclim.org/data/bioclim.html) measured at 100 geographic locations,
with species richness as the response variable. Variables are organized into
correlated blocks representing temperature (BIO1-BIO11) and precipitation (BIO12-BIO19).
}
\details{
This dataset demonstrates a common problem in ecological modeling: bioclimatic
predictors are highly correlated within groups (temperature variables BIO1-BIO11 are
highly correlated; precipitation variables BIO12-BIO19 are moderately correlated),
leading to multicollinearity issues. The species richness response depends on a subset
of predictors.

\strong{Use case}: Demonstrating \code{corrPrune()} and \code{modelPrune()} for reducing correlated
environmental predictors before fitting species distribution models.
}
\examples{
data(bioclim_example)

# The 19 WorldClim bioclimatic variables (https://www.worldclim.org/data/bioclim.html)
# Many are highly correlated, making them ideal for pruning

# Remove highly correlated variables
pruned <- corrPrune(bioclim_example[, -1], threshold = 0.7)
ncol(pruned)  # Reduced from 19 to ~8 variables

# Model-based pruning with VIF
model_data <- modelPrune(species_richness ~ .,
                         data = bioclim_example,
                         limit = 5)
attr(model_data, "selected_vars")
}
\seealso{
\code{\link[=corrPrune]{corrPrune()}}, \code{\link[=modelPrune]{modelPrune()}}
}
\keyword{datasets}
