% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrSubset.R
\name{corrSubset}
\alias{corrSubset}
\title{Extract Variable Subsets from a CorrCombo Object}
\usage{
corrSubset(res, df, which = "best", keepExtra = FALSE)
}
\arguments{
\item{res}{A \code{\link{CorrCombo}} object returned by \code{corrSelect} or \code{MatSelect}.}

\item{df}{A data frame or matrix. Must contain all variables listed in \code{res@names}.
Columns not in \code{res@names} are ignored unless \code{keepExtra = TRUE}.}

\item{which}{Subsets to extract. One of:
\itemize{
\item \code{"best"} (default) or \code{1}: the top‐ranked subset.
\item A single integer (e.g. \code{2}): the nth ranked subset.
\item A vector of integers (e.g. \code{1:3}): multiple subsets.
\item \code{"all"}: all available subsets.
}
Subsets are ranked by decreasing size, then increasing average correlation.}

\item{keepExtra}{Logical. If \code{TRUE}, columns in \code{df} not in \code{res@names}
(e.g., factors, characters) are retained. Defaults to \code{FALSE}.}
}
\value{
A data frame if a single subset is extracted, or a list of data frames if multiple
subsets are extracted. Each data frame contains the selected variables (and optionally extras).
}
\description{
Extracts one or more variable subsets from a \code{\link{CorrCombo}} object as data frames.
Typically used after \code{\link{corrSelect}} or \code{\link{MatSelect}} to obtain filtered
versions of the original dataset containing only low‐correlation variable combinations.
}
\note{
A warning is issued if any rows contain missing values in the selected variables.
}
\examples{
# Simulate input data
set.seed(123)
df <- as.data.frame(matrix(rnorm(100), nrow = 10))
colnames(df) <- paste0("V", 1:10)

# Compute correlation matrix
cmat <- cor(df)

# Select subsets using corrSelect
res <- corrSelect(cmat, threshold = 0.5)

# Extract the best subset (default)
corrSubset(res, df)

# Extract the second-best subset
corrSubset(res, df, which = 2)

# Extract the first three subsets
corrSubset(res, df, which = 1:3)

# Extract all subsets
corrSubset(res, df, which = "all")

# Extract best subset and retain additional numeric column
df$CopyV1 <- df$V1
corrSubset(res, df, which = 1, keepExtra = TRUE)

}
\seealso{
\code{\link{corrSelect}}, \code{\link{MatSelect}}, \code{\link{CorrCombo}}
}
