% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosimmr_ffvb.R
\name{cosimmr_ffvb}
\alias{cosimmr_ffvb}
\title{Run a \code{cosimmr_input} object through the Fixed Form Variational
Bayes(FFVB) function}
\usage{
cosimmr_ffvb(
  cosimmr_in,
  prior_control = list(mu_0 = rep(0, (cosimmr_in$n_sources * cosimmr_in$n_covariates)),
    mu_log_sig_sq_0 = rep(0, cosimmr_in$n_tracers), sigma_0 = 1, tau_shape = rep(1,
    cosimmr_in$n_tracers), tau_rate = rep(1, cosimmr_in$n_tracers)),
  ffvb_control = list(n_output = 3600, S = 500, P = 50, beta_1 = 0.75, beta_2 = 0.75, tau
    = 500, eps_0 = 0.0011, t_W = 500)
)
}
\arguments{
\item{cosimmr_in}{An object created via the function \code{\link{cosimmr_load}}}

\item{prior_control}{A list of values including arguments named \code{mu_0}
(prior for mu), and \code{sigma_0} (prior for sigma).}

\item{ffvb_control}{A list of values including arguments named \code{n_output}
(number of rows in theta output), \code{S} (number of samples taken at each
iteration of the algorithm), \code{P} (patience parameter), \code{beta_1}
and \code{beta_2} (adaptive learning weights), \code{tau} (threshold for
exploring learning space), \code{eps_0} (fixed learning rate),
\code{t_W} (rolling window size)}
}
\value{
An object of class \code{cosimmr_output} with two named top-level
components: \item{input }{The \code{cosimmr_input} object given to the
\code{cosimmr_ffvb} function} \item{output }{A set of outputs produced by
the FFVB function. These can be analysed using the
\code{\link{summary.cosimmr_output}} and \code{\link{plot.cosimmr_output}}
functions.}
}
\description{
This is the main function of cosimmr. It takes a \code{cosimmr_input} object
created via \code{\link{cosimmr_load}}, runs it in fixed form
Variational Bayes to determine the dietary proportions, and then
outputs a \code{cosimmr_output} object for further analysis and plotting
via \code{\link{plot.cosimmr_output}}.
}
\examples{
\donttest{
## See the package vignette for a detailed run through of these examples

# Data set 1: 10 obs on 2 isos, 4 sources, with tefs and concdep
data(geese_data_day1)
x = c(1,2,3,2,1,3,2,1,2)
cosimmr_1 <- with(
  geese_data_day1,
  cosimmr_load(
    formula = mixtures ~ x,
    source_names = source_names,
    source_means = source_means,
    source_sds = source_sds,
    correction_means = correction_means,
    correction_sds = correction_sds,
    concentration_means = concentration_means
  )
)

# Plot
plot(cosimmr_1)

# Print
cosimmr_1

# FFVB run
cosimmr_1_out <- cosimmr_ffvb(cosimmr_1)

# Print it
print(cosimmr_1_out)

# Summary
summary(cosimmr_1_out, type = "correlations")
summary(cosimmr_1_out, type = "statistics")
ans <- summary(cosimmr_1_out, type = c("quantiles", "statistics"))

# Plot
plot(cosimmr_1_out, type = "beta_boxplot", cov_name = "x")
plot(cosimmr_1_out, type = "beta_histogram", cov_name = "x")

}
}
\references{
Andrew C. Parnell, Donald L. Phillips, Stuart Bearhop, Brice X.
Semmens, Eric J. Ward, Jonathan W. Moore, Andrew L. Jackson, Jonathan Grey,
David J. Kelly, and Richard Inger. Bayesian stable isotope mixing models.
Environmetrics, 24(6):387–399, 2013.

Andrew C Parnell, Richard Inger, Stuart Bearhop, and Andrew L Jackson.
Source partitioning using stable isotopes: coping with too much variation.
PLoS ONE, 5(3):5, 2010.
}
\seealso{
\code{\link{cosimmr_load}} for creating objects suitable for this
function, \code{\link{plot.cosimmr_input}} for creating isospace plots,
\code{\link{summary.cosimmr_output}} for summarising output, and
\code{\link{plot.cosimmr_output}} for plotting output.
}
\author{
Emma Govan <emmagovan@gmail.com>, Andrew Parnell
}
