% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{simmr_data_2}
\alias{simmr_data_2}
\title{A 3-isotope fake stable isotope mixing data set}
\format{
A list with the following elements
\describe{
  \item{mixtures}{A three column matrix containing delta 13C, delta 15N, and delta 34S values respectively}
  \item{source_names}{A character vector of the food source names}
  \item{tracer_names}{A character vector of the tracer names (d13C, d15N, d34S)}
  \item{source_means}{A matrix of source mean values for the tracers in the same order as \code{mixtures} above}
  \item{source_sds}{A matrix of source sd values for the tracers in the same order as \code{mixtures} above}
  \item{correction_means}{A matrix of TEFs mean values for the tracers in the same order as \code{mixtures} above}
  \item{correction_sds}{A matrix of TEFs sd values for the tracers in the same order as \code{mixtures} above}
  \item{concentration_means}{A matrix of concentration dependence mean values for the tracers in the same order as \code{mixtures} above}

}
}
\usage{
simmr_data_2
}
\description{
A fake data set with 30 observations on 3 isotopes, with 4 sources, and with corrections/trophic enrichment factors (TEFs or TDFs), and concentration dependence means
}
\keyword{datasets}
