% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srcref_df.R
\name{trace_srcrefs_df}
\alias{trace_srcrefs_df}
\title{Create a data.frame of coverage trace srcref objects}
\usage{
trace_srcrefs_df(x)
}
\arguments{
\item{x}{A \code{\link[covr]{package_coverage}} coverage object, from which
the name of the package used is extracted.}
}
\value{
A \code{data.frame}, where each record it a trace \code{srcref} with
variables:

\describe{
\item{name}{A \code{character} identifier. This will use the names of the
elements of a \code{\link[covr:package_coverage]{coverage}} object,
which are \code{srcref} "keys".}
\item{srcref}{A \code{srcref} object of the trace source code location}
}
}
\description{
Extract \code{\link[covr:package_coverage]{coverage}} traces. Traces are the
traced lines of code counted when evaluating code coverage, which are used
for counting expression evaluation. Each traced is a unique expression within
a package's source code.
}
\examples{
options(covr.record_tests = TRUE)
pkg_path <- system.file("examplepkg", package = "covtracer")
cov <- covr::package_coverage(pkg_path)
trace_srcrefs_df(cov)

}
\seealso{
srcrefs test_trace_mapping

Other srcrefs_df: 
\code{\link{pkg_srcrefs_df}()},
\code{\link{test_srcrefs_df}()}
}
\concept{srcrefs_df}
