% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_shape.R
\name{select_shape}
\alias{select_shape}
\title{Use model selection to select a shape for each target}
\usage{
select_shape(
  cpo,
  subset = NULL,
  sp = NULL,
  bss = c("micv", "mdcx", "cv", "cx", "lin", "tp", "null"),
  family = c("nb", "gaussian"),
  score = "gcv",
  cp_type = c("cp_1se", "cp_min")
)
}
\arguments{
\item{cpo}{a cpam object}

\item{subset}{character vector; names of targets or genes (if \code{cpo$gene_level = T})
for which changepoints will be estimated}

\item{sp}{numerical >= 0; supply a fixed smoothing parameter. If NULL (default), the smoothing
parameter is estimated. Note, this fixed value is in any case applied only to
shape constrained bases (i.e., not \code{bs = 'tp'}).}

\item{bss}{character vector; names of candidate spline bases (i.e., candidate shape types).}

\item{family}{character; negative binomial ("nb", default) or Gaussian ("gaussian")}

\item{score}{character; model selection score, either Generalised Cross Validation ("gcv") or
Akaike Information Criterion ("aic")}

\item{cp_type}{character; if changepoints have been estimated using \code{\link[=estimate_changepoint]{estimate_changepoint()}},
which selection rule should be used. See \code{\link[=estimate_changepoint]{estimate_changepoint()}} for details.}
}
\value{
a cpam object with the selected shapes added to the slot "shapes"
}
\description{
Use model selection to select a shape for each target
}
\details{
The function selects the best shape from a list of candidate shapes for each target.
It is typically the last step in the analysis, called after p-values have
been estimated using \code{\link[=compute_p_values]{compute_p_values()}} and changepoints have
been estimated using \code{\link[=estimate_changepoint]{estimate_changepoint()}}.

Two shape selections are generated. The first selecting among linear,
convex and concave shape classes and their monotonic variants (or the shape
set given by bss), and the second selecting among the first options plus an
'unconstrained' smooth. The inclusion of the 'unconstrained' type provides
the flexibility to detect targets beyond simpler trends.
For computational reasons, as per the changepoint estimation,
shapes are selected only for those genes, or their isoforms,
identified as significant at the chosen FDR threshold. This is
overridden by providing a subset of target names to the \code{subset} argument,
provided these targets have estimated changepoints.
}
\examples{
library(cpam)

# load example data
load(system.file("extdata", "exp_design_example.rda", package = "cpam"))
load(system.file("extdata", "count_matrix_example.rda", package = "cpam"))

# Using a small subset of the example data
cpo <- prepare_cpam(exp_design = exp_design_example,
                    count_matrix = count_matrix_example[1:20,],
                    gene_level = TRUE,
                    num_cores = 1)
cpo <- compute_p_values(cpo)
cpo <- estimate_changepoint(cpo)
cpo <- select_shape(cpo)
cpo$shapes


}
