% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chist.R
\name{chist}
\alias{chist}
\title{Circular Histogram and Rose Diagram}
\usage{
chist(
  x,
  nbins = 36,
  radius = 1/sqrt(base::pi),
  area.prop = TRUE,
  prob = TRUE,
  total.area = 1,
  nlabels = 4,
  col = "lightblue",
  border = "skyblue4",
  m = NA,
  xlim = NULL,
  ylim = NULL,
  main = NULL
)
}
\arguments{
\item{x}{a numeric vector storing angular values between 0 and 2 pi, or
an object that can be coerced to.}

\item{nbins}{the number of bins of the circular histogram.  Internally,
it is rounded to a multiple of 4.}

\item{radius}{the radius of the reference circle. If \code{radius = 0},
a rose diagram is produced; if \code{radius > 0}, a circular histogram
is produced outside the reference circle.}

\item{area.prop}{logical; if \code{TRUE}, an area-proportional
transformation is applied; if \code{FALSE}, a height-proportional
transformationis applied.}

\item{prob}{logical; if \code{TRUE}, the circular histogram graphic is a
representation of probability densities; if \code{FALSE}, a
representation of frequencies.}

\item{total.area}{a positive number specifying the total area under the
density curve. If \code{total.area = NULL}, no scaling is applied, the
plot is in the original scale. If \code{area.prop = TRUE}, the total area 
is automatically unity without scaling.}

\item{nlabels}{integer, for the number of levels for the
density/frequency values to be plotted; if \code{0}, no label is
plotted}

\item{col}{the color to fill the bars.}

\item{border}{the color of the border around the bars.}

\item{m}{the number of points within each bin to plot the circular
histogram. The larger the number is, the smoother the plot looks.}

\item{xlim}{numeric vectors of length 2, giving the x coordinates
ranges.}

\item{ylim}{numeric vectors of length 2, giving the y coordinates
ranges.}

\item{main}{the main title (on top)}
}
\value{
No return value
}
\description{
Function \code{chist} can be used to plot 2-dimensional 
  histograms and rose diagrams for circular data.
}
\examples{
# 600 observations from two von Mises distributions
library(circular)
x = c(rvonmises(200, circular(pi/4), 5), rvonmises(400, circular(pi), 20))

chist(x)                           # area-proportional circular histgram
chist(x, area = FALSE)             # height-proportional circular histgram
chist(x, radius=0)                 # area-proportional rose diagram
chist(x, radius=0, area=FALSE)     # height-proportional rose diagram

chist(x, prob=FALSE)               # labels for frequency
chist(x, nlabels=0)                # no label
chist(x, xlim=c(-1.7,1))           # use xlim
chist(x, area=FALSE, total=2)      # with scaling
chist(x, area=FALSE, total=NULL)   # without scaling

}
\references{
Xu, D. and Wang, Y. (2020). Area-proportional Visualization for
Circular Data. \emph{Journal of Computational and Graphical
Statistics}, \bold{29}, 351-357.
}
\seealso{
\code{\link{cbarplot}}, \code{\link{cdensity}}, \code{\link{cdotplot}}
}
\author{
Danli Xu <dxu452@aucklanduni.ac.nz>, Yong Wang <yongwang@auckland.ac.nz>
}
\concept{circular histogram}
\concept{rose diagram}
