% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml2json.R
\name{xml2json}
\alias{xml2json}
\title{XML to JSON}
\usage{
xml2json(
  xml,
  spaces = 2L,
  linebreaks = FALSE,
  replacer = NULL,
  attributeNamePrefix = "@_",
  textNodeName = "#text",
  ignoreAttributes = FALSE,
  ignoreNameSpace = FALSE,
  parseNodeValue = TRUE,
  parseAttributeValue = TRUE,
  trimValues = TRUE
)
}
\arguments{
\item{xml}{either a XML file or some XML given as a character string}

\item{spaces}{an integer, the indentation}

\item{linebreaks}{Boolean, whether to break the lines in the JSON string
when there are some linebreaks; this generates an invalid JSON string}

\item{replacer}{character vector, the body of the second argument of
\code{JSON.stringify} (the replacer function), or \code{NULL}}

\item{attributeNamePrefix}{prefix for the attributes}

\item{textNodeName}{name of text nodes, which appear for nodes which have
both a text content and some attributes}

\item{ignoreAttributes}{Boolean, whether to ignore the attributes}

\item{ignoreNameSpace}{Boolean, whether to ignore the namespaces}

\item{parseNodeValue}{Boolean, whether to parse the node values to numbers
if possible}

\item{parseAttributeValue}{Boolean, whether to parse the attribute values to
numbers if possible}

\item{trimValues}{Boolean, whether to trim the values}
}
\value{
A JSON string.
}
\description{
Convert XML to a JSON string.
}
\examples{
xml <- system.file("extdata", "order-schema.xml", package = "xml2")
cat(xml2json(xml))
#
js <- c(
  'if(key === "@_type"){',
  '  return undefined;',
  '} else if(key === "@_name"){',
  '  return value.toUpperCase();',
  '}',
  'return value;'
)
cat(xml2json(xml, linebreaks = TRUE, replacer = js))
}
