% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mcmc_mix2}
\alias{mcmc_mix2}
\title{Markov chain Monte Carlo for 2-component discrete extreme value mixture distribution}
\usage{
mcmc_mix2(
  x,
  count,
  u_set,
  u,
  alpha,
  theta,
  shape,
  sigma,
  a_psiu,
  b_psiu,
  a_alpha,
  b_alpha,
  a_theta,
  b_theta,
  m_shape,
  s_shape,
  a_sigma,
  b_sigma,
  positive,
  a_pseudo,
  b_pseudo,
  pr_power,
  iter,
  thin,
  burn,
  freq,
  invt,
  mc3_or_marg = TRUE,
  constrained = FALSE
)
}
\arguments{
\item{x}{Vector of the unique values (positive integers) of the data}

\item{count}{Vector of the same length as x that contains the counts of each unique value in the full data, which is essentially rep(x, count)}

\item{u_set}{Positive integer vector of the values u will be sampled from}

\item{u}{Positive integer, initial value of the threshold}

\item{alpha}{Real number greater than 1, initial value of the parameter}

\item{theta}{Real number in (0, 1], initial value of the parameter}

\item{shape}{Real number, initial value of the parameter}

\item{sigma}{Positive real number, initial value of the parameter}

\item{a_psiu, b_psiu, a_alpha, b_alpha, a_theta, b_theta, m_shape, s_shape, a_sigma, b_sigma}{Scalars, real numbers representing the hyperparameters of the prior distributions for the respective parameters. See details for the specification of the priors.}

\item{positive}{Boolean, is alpha positive (TRUE) or unbounded (FALSE)? Ignored if constrained is TRUE}

\item{a_pseudo}{Positive real number, first parameter of the pseudoprior beta distribution for theta in model selection; ignored if pr_power = 1.0}

\item{b_pseudo}{Positive real number, second parameter of the pseudoprior beta distribution for theta in model selection; ignored if pr_power = 1.0}

\item{pr_power}{Real number in [0, 1], prior probability of the discrete power law (below u). Overridden if constrained is TRUE}

\item{iter}{Positive integer representing the length of the MCMC output}

\item{thin}{Positive integer representing the thinning in the MCMC}

\item{burn}{Non-negative integer representing the burn-in of the MCMC}

\item{freq}{Positive integer representing the frequency of the sampled values being printed}

\item{invt}{Vector of the inverse temperatures for Metropolis-coupled MCMC}

\item{mc3_or_marg}{Boolean, is invt for parallel tempering / Metropolis-coupled MCMC (TRUE, default) or marginal likelihood via power posterior (FALSE)?}

\item{constrained}{Boolean, are alpha & shape constrained such that 1/shape+1 > alpha > 1 with the powerlaw assumed in the body & "continuity" at the threshold u (TRUE), or is there no constraint between alpha & shape, with the former governed by positive, and no powerlaw and continuity enforced (FALSE, default)?}
}
\value{
A list: $pars is a data frame of iter rows of the MCMC samples, $fitted is a data frame of length(x) rows with the fitted values, amongst other quantities related to the MCMC
}
\description{
\code{mcmc_mix2} returns the posterior samples of the parameters, for fitting the 2-component discrete extreme value mixture distribution. The samples are obtained using Markov chain Monte Carlo (MCMC).
}
\details{
In the MCMC, a componentwise Metropolis-Hastings algorithm is used. The threshold u is treated as a parameter and therefore sampled. The hyperparameters are used in the following priors: u is such that the implied unique exceedance probability psiu ~ Uniform(a_psi, b_psi); alpha ~ Normal(mean = a_alpha, sd = b_alpha); theta ~ Beta(a_theta, b_theta); shape ~ Normal(mean = m_shape, sd = s_shape); sigma ~ Gamma(a_sigma, scale = b_sigma). If pr_power = 1.0, the discrete power law (below u) is assumed, and the samples of theta will be all 1.0. If pr_power is in (0.0, 1.0), model selection between the polylog distribution and the discrete power law will be performed within the MCMC.
}
\seealso{
\code{\link{mcmc_pol}} and \code{\link{mcmc_mix3}} for MCMC for the Zipf-polylog and 3-component discrete extreme value mixture distributions, respectively.
}
