% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRISP_functions.R
\name{sim.data}
\alias{sim.data}
\title{Simulate Data to Use with \code{\link{crisp}}.}
\usage{
sim.data(n, scenario, noise = 1, X = NULL)
}
\arguments{
\item{n}{The number of observations.}

\item{scenario}{The simulation scenario to use. Options are 1 (additive model), 2 (interaction model), 3 ('tetris' model), or 4 (smooth model), which correspond to the simulation scenarios of Section 3 of the CRISP paper. Each scenario has two covariates.}

\item{noise}{The standard deviation of the normally-distributed noise that is added to the signal.}

\item{X}{The \code{n} x 2 covariate matrix, which is automatically generated if not specified.}
}
\value{
A list containing:
\itemize{
\item{\code{X}: }{An \code{n} x 2 covariate matrix.}
\item{\code{y}: }{An \code{n}-vector containing the response values.}
\item{Other elements: }{As specified by the user.}
}
}
\description{
This function generates data according to the simulation scenarios considered in Section 3 of the CRISP paper (and plotted in Figure 2 of the paper).
}
\examples{
#See ?'crisp-package' for a full example of how to use this package

#generate data (using a very small 'n' for illustration purposes)
set.seed(1)
data <- sim.data(n = 15, scenario = 2)

#plot the mean model for the scenario from which we generated data
plot(data)
}
\seealso{
\code{\link{crisp}}, \code{\link{crispCV}}
}

