% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRISP_functions.R
\name{summary}
\alias{summary}
\alias{summary.crisp}
\alias{summary.crispCV}
\title{Summarizes Fit from \code{\link{crisp}} or \code{\link{crispCV}}.}
\usage{
\method{summary}{crisp}(object, lambda.index = NULL, ...)

\method{summary}{crispCV}(object, ...)
}
\arguments{
\item{object}{An object of class \code{crisp} or \code{crispCV}, which result from running the \code{\link{crisp}} or \code{\link{crispCV}} functions, respectively.}

\item{lambda.index}{The index for the desired value of lambda, i.e., \code{object$lambda.seq[lambda.index]}. By default, fits for all values of lambda are summarized.}

\item{...}{Additional arguments to be passed, which are ignored in this function.}
}
\value{
None.
}
\description{
This function summarizes fit of the class \code{crispCV} or \code{crisp}.
}
\examples{
\dontrun{
#See ?'crisp-package' for a full example of how to use this package
#generate data (using a very small 'n' for illustration purposes)
set.seed(1)
data <- sim.data(n = 15, scenario = 2)

#fit model for a range of tuning parameters, i.e., lambda values
#lambda sequence is chosen automatically if not specified
crisp.out <- crisp(X = data$X, y = data$y)
#or fit model and select lambda using 2-fold cross-validation
#note: use larger 'n.fold' (e.g., 10) in practice
crispCV.out <- crispCV(X = data$X, y = data$y, n.fold = 2)

#summarize all of the fits
summary(crisp.out)
#or just summarize a single fit
#we examine the fit with an index of 25. that is, lambda of
crisp.out$lambda.seq[25]
summary(crisp.out, lambda.index = 25)
#lastly, we can summarize the fit chosen using cross-validation
summary(crispCV.out)
}
}

