% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crrcbcv.R
\name{crrcbcv}
\alias{crrcbcv}
\title{Bias-Corrected Variance for Competing Risks Regression with Clustered Data}
\usage{
crrcbcv(
  beta,
  ftime,
  fstatus,
  cov1,
  cov2,
  tf,
  cluster,
  failcode = 1,
  cencode = 0,
  subset,
  na.action = na.omit,
  var.type = "MD"
)
}
\arguments{
\item{beta}{the estimated regression coefficients from \code{crrc}}

\item{ftime}{vector of failure/censoring times}

\item{fstatus}{vector with a unique code for each failure type and a separate code for censored observations}

\item{cov1}{matrix (nobs x ncovs) of fixed covariates (either cov1, cov2, or both are required)}

\item{cov2}{matrix of covariates that will be multiplied by functions of time;
if used, often these covariates would also appear in cov1 to give a prop hazards effect plus a time interaction}

\item{tf}{functions of time. A function that takes a vector of times as an argument and returns a matrix whose
jth column is the value of the time function corresponding to the jth column of cov2 evaluated at the
input time vector. At time \code{tk}, the model includes the term \code{cov2[,j]*tf(tk)[,j]} as a covariate}

\item{cluster}{clustering indicator}

\item{failcode}{code of fstatus that denotes the failure type of interest}

\item{cencode}{code of fstatus that denotes censored observations}

\item{subset}{a logical vector specifying a subset of cases to include in the analysis}

\item{na.action}{a function specifying the action to take for any cases missing any of
ftime, fstatus, cov1, cov2, cengroup, or subset}

\item{var.type}{a string or a vector of strings with value(s) selected from \{\code{"MD"}, \code{"KC"}, \code{"FG"}, \code{"MBN"}\}}
}
\value{
Returns a list of class crr, with components corresponding to \code{var.type}
\describe{
\item{\verb{$MD}}{the MD-type bias-corrected variance covariance matrix for \code{beta}}
\item{\verb{$KC}}{the KC-type bias-corrected variance covariance matrix for \code{beta}}
\item{\verb{$FG}}{the FG-type bias-corrected variance covariance matrix for \code{beta}}
\item{\verb{$MBN}}{the MBN-type bias-corrected variance covariance matrix for \code{beta}}
}
}
\description{
Small-sample bias-corrected variance for regression modeling using proportional subdistribution hazards with
clustered right censored data. (Zhou et al., 2012) Failure times within the same cluster are dependent.

Four types of bias correction are included: the MD-type correction by Mancl and DeRouen (2001),
the KC-type correction by Kauermann and Carroll (2001), the FG-type correction by Fay and Graubard (2001),
and the MBN-type correction by Morel, Bokossa, and Neerchal (2003).
}
\examples{
library(crrcbcv)
data(cls)
mod.est = crrc(ftime=cls$T_obs, fstatus=cls$eps, cov1=cls[,c('X_1','X_2')], cluster=cls$I)
crrcbcv(beta=mod.est$coef, ftime=cls$T_obs, fstatus=cls$eps, cov1=cls[,c('X_1','X_2')],
cluster=cls$I, var.type=c('MD','KC','FG','MBN'))
}
\references{
Chen X, Li F. (2022). Finite-sample adjustments in variance estimators for
clustered competing risks regression. Statistics in Medicine. 00(Under Review): 1-24.

Zhou B, Fine J, Latouche A, Labopin M. (2012). Competing risks regression for clustered Data. Biostatistics.
13(3): 371-383.
}
\seealso{
\code{crrSC}
}
\author{
Xinyuan Chen, \verb{<xchen@math.msstate.edu>}

Fan Li, \verb{<fan.f.li@yale.edu>}
}
