% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance_matrix.R
\name{make_non_negative}
\alias{make_non_negative}
\title{Make non-negative}
\usage{
make_non_negative(Y, allowSlack = FALSE)
}
\arguments{
\item{Y}{Matrix to be positivized.}

\item{allowSlack}{Can colSums and rowSums be modified?}
}
\value{
A non-negative matrix, except if it is impossible to balance the
matrix.
}
\description{
Modifies as little as possible the entries of a matrix
in order to make them non-negative, keeping row and column totals unchanged.
}
\examples{
Y <- c(1,2,-1,1,
       2,2,3,1,
       1,1,-2,3) |>
       matrix(nrow = 3)
X <- make_non_negative(Y)
Y
X |> round(2)
rowSums(Y)
rowSums(X)
colSums(Y)
colSums(X)
set.seed(2)
Y <- rnorm(3*5) |> matrix(3,5) |> round(3)
Y
tryCatch(make_non_negative(Y), error = function(e) {
  print(e)
})
make_non_negative(Y, allowSlack = TRUE) |> round()
}
