% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecb.R
\docType{data}
\name{ecb}
\alias{ecb}
\title{ECB excess reserve data}
\format{
\code{ecb} a list containing
\itemize{
  \item \code{rate} the normalised EONIA rate.
  \item \code{x} a matrix including the ECB excess reserves and various regressors.
}
}
\usage{
ecb
}
\description{
The short-term interest rate used for the European Central Bank (ECB) is the volume-weighted Euro Overnight Index Average (EONIA) rate.
Various explanatory variables are provided, as listed in the Chen et al. (2023).
Data are collected from 1999 to 2019, resulting in 239 maintenance periods where all data is available.
}
\examples{
plot(ecb$x[,1],ecb$rate,xlab="Excess Reserves",ylab="Rate")

}
\references{
Chen, Z., Kourentzes, N., & Veyrune, R. (2023). \href{https://www.imf.org/en/Publications/WP/Issues/2023/09/01/Modeling-the-Reserve-Demand-to-Facilitate-Central-Bank-Operations-538754}{Modeling the Reserve Demand to Facilitate Central Bank Operations.} IMF Working Papers, 2023(179).
}
\keyword{datasets}
