% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_growth.R
\name{fit_growth}
\alias{fit_growth}
\alias{fit_growth,list,missing-method}
\alias{fit_growth,EffectScenario,ANY-method}
\alias{fit_growth,ScenarioSequence,ANY-method}
\alias{fit_growth,ANY,ANY-method}
\alias{fit_growth,LemnaSetac,missing-method}
\alias{fit_growth,LemnaSchmitt,missing-method}
\alias{fit_growth,Magma,missing-method}
\title{Fit growth parameters}
\usage{
fit_growth(x, data, ...)

\S4method{fit_growth}{ANY,ANY}(x, data, ...)

\S4method{fit_growth}{LemnaSetac,missing}(x, data, par, log_scale = TRUE, verbose = FALSE, ...)

\S4method{fit_growth}{LemnaSchmitt,missing}(x, data, par, log_scale = TRUE, verbose = FALSE, ...)

\S4method{fit_growth}{Magma,missing}(x, data, par, log_scale = TRUE, verbose = FALSE, ...)
}
\arguments{
\item{x}{a \link{scenario} or a list of \link{caliset} objects}

\item{data}{toxicological trial data to fit growth parameters to: required if
\code{x} is either a \link{scenario} or the result of a fit. See Section \emph{Data}
for details.}

\item{...}{additional arguments passed through to \code{\link[=calibrate]{calibrate()}}}

\item{par}{named vector, of parameters to fit and their starting values}

\item{log_scale}{logical, if \code{TRUE} then fitting will be performed on log-transformed
observations and predictions, else the data will be used as-is}

\item{verbose}{logical, if \code{TRUE} then info messages are printed to the console}
}
\value{
a list
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\section{Methods (by class)}{
\itemize{
\item \code{fit_growth(x = ANY, data = ANY)}: Default handler

\item \code{fit_growth(x = LemnaSetac, data = missing)}: Fit growth parameters of \link{Lemna_SETAC} scenarios

\item \code{fit_growth(x = LemnaSchmitt, data = missing)}: Fit growth parameters of \link{Lemna_Schmitt} scenarios

\item \code{fit_growth(x = Magma, data = missing)}: Fit growth parameters of \link{Magma} scenarios

}}
\examples{
# Use experimental data from control trial ('T0') to fit growth rate
ctrl <- schmitt2013[schmitt2013$trial == "T0" ,]

# Set up a scenario, provide dummy parameter values where necessary
sc <- Lemna_Schmitt() \%>\%
  set_init(c(BM=0.0012)) \%>\%
  set_param(c(EC50=1, b=1, P_up=1))

# Run fitting routine
fit_growth(sc, data=ctrl, verbose=TRUE)
}
