% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.download.binary.r
\name{gl.download.binary}
\alias{gl.download.binary}
\title{Support function to download binaries from github}
\usage{
gl.download.binary(
  software = NULL,
  os = NULL,
  branch = "main",
  out.dir = tempdir(),
  verbose = 2
)
}
\arguments{
\item{software}{name of the software package to download. Currently supported are: "epos", "NeEstimator", "Stairway2" and  "Gone". Please note, depending on the software several files will be downloaded}

\item{os}{the operating system to download the binary for. Currently supported are: "windows", "mac" and "linux". Please be aware some binaries are not available for all operating systems.}

\item{branch}{which branch to download from (leave empty for the main branch and there should not be a reason to change that)}

\item{out.dir}{the path where to save the binary. If left empty the binary will be saved in the temporary directory.}

\item{verbose}{.If zero, suppresses output messages. Default is zero}
}
\value{
functions returns NULL
}
\description{
This functions supports the download of binaries from github. Those binaries are compiled files that allow to run dartR functions that integrate third party software such as epos (gl.run.epos), NeEstimator (gl.LDNe) or Structure (gl.run.structure). Please be aware this is just to allow for easy install and use of dartR functions seemlessly. We have explicitely asked the authors of the software for permission to include those binaries here. Understandably some authors prefer to direct users to their own websites to download the software. Here a comment is issued by the function how to do so. Please note: **The third party packages are the work of others and please make the effort to cite them accordingly**. You find the citations under the help pages of the respective functions, for example ?gl.run.epos.
}
\examples{
gl.download.binary
\donttest{
dartRverse_install()
}
}
