% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findOptimalThreadCount.R
\name{findOptimalThreadCount}
\alias{findOptimalThreadCount}
\title{Function that finds the optimal (fastest) thread count for different \code{data.table} functions}
\usage{
findOptimalThreadCount(rowCount, colCount, times = 10, verbose = FALSE)
}
\arguments{
\item{rowCount}{The number of rows in the \code{data.table}.}

\item{colCount}{The number of columns in the \code{data.table}.}

\item{times}{The number of times the benchmarks are to be run.}

\item{verbose}{Option (logical) to enable or disable detailed message printing.}
}
\value{
A \code{data.table} of class \code{data_table_threads_benchmark} containing the optimal thread count for each \code{data.table} function.
}
\description{
This function finds the optimal thread count for running \code{data.table} functions with maximum efficiency.
}
\details{
Iteratively runs benchmarks with increasing thread counts and determines the optimal number of threads for each \code{data.table} function.
}
\examples{
# Finding the best performing thread count for each benchmarked data.table function
# with a data size of 1000 rows and 10 columns:
(optimalThreads <- data.table.threads::findOptimalThreadCount(1e3, 10))
}
