% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifier.R
\name{identifier}
\alias{identifier}
\alias{identifier<-}
\title{Get or Set the Identifier of a Dataset or Metadata Record}
\usage{
identifier(x)

identifier(x, overwrite = TRUE) <- value
}
\arguments{
\item{x}{A \code{\link[=dataset_df]{dataset_df()}} object or a \code{\link[utils:bibentry]{utils::bibentry}} object (including
\code{\link[=dublincore]{dublincore()}} or \code{\link[=datacite]{datacite()}} records).}

\item{overwrite}{Logical. If \code{TRUE} (default), any existing identifier is
replaced. If \code{FALSE}, an existing identifier is preserved unless it is
\code{":unas"} or \code{":tba"}.}

\item{value}{A character string giving the identifier. Can be named (e.g.,
\code{c(doi = "...")}) or unnamed. Numeric values are coerced to character.}
}
\value{
For \code{identifier()}, the current identifier as a character string. For
\verb{identifier<-()}, the updated object (invisible).
}
\description{
Retrieve or assign the \code{identifier} attribute of a dataset or
bibliographic metadata object.
}
\details{
An \emph{identifier} provides an unambiguous reference to a resource.
Recommended practice is to supply a persistent identifier string, such as a
DOI, ISBN, or URN, that conforms to a recognized identification system.

Both \href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/#identifier}{Dublin Core}
and \href{https://support.datacite.org/docs/datacite-metadata-schema-v44-mandatory-properties#1-identifier}{DataCite 4.4}
define \code{identifier} as a core property. If the identifier is a DOI, it will
also be stored in the \code{doi} field of the metadata record.

Although \code{identifier} is not part of the minimal Dublin Core term set, it is
always included in \code{dataset} metadata for compatibility with publishing and
indexing systems. You may omit it if working under a strict DC profile.

For best practice in choosing identifier schemes, see the \href{https://www.iana.org/assignments/uri-schemes/uri-schemes.xhtml}{IANA-registered URI schemes}.
}
\examples{
orange_copy <- orange_df

# Get the current identifier
identifier(orange_copy)

# Set a new identifier (e.g., a DOI)
identifier(orange_copy) <- "https://doi.org/10.9999/example.doi"

# Prevent accidental overwrite
identifier(orange_copy, overwrite = FALSE) <- "https://example.org/id"

# Use numeric and NULL values
identifier(orange_copy) <- 12345
identifier(orange_copy) <- NULL # Sets ":unas"

}
\concept{Reference metadata functions}
